# Deployment Instructions

## Prerequisites
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache Web Server (with `mod_rewrite` enabled)
- Composer

## Installation Steps

1.  **Database Setup**
    - Create a new MySQL database named `uae_docs_db`.
    - Import the `database.sql` file into your database.
    - You can use phpMyAdmin or command line:
      ```bash
      mysql -u root -p uae_docs_db < database.sql
      ```

2.  **Project Configuration**
    - Rename `.env` (if needed) and update the database credentials:
      ```ini
      DB_HOST=localhost
      DB_NAME=uae_docs_db
      DB_USER=root
      DB_PASS=your_password
      JWT_SECRET=your_secret_key
      ```

3.  **Dependencies**
    - Run Composer to install dependencies:
      ```bash
      cd uae-docs-api
      composer install
      ```
    - **Note**: If you encounter issues with `composer install` (e.g., missing extensions), ensure your PHP environment has the necessary extensions enabled in `php.ini`.

4.  **Apache Configuration**
    - Ensure your Apache virtual host points to the `htdocs` directory.
    - The API is accessed via `http://localhost/doc_process/uae-docs-api/public/index.php`.
    - The Frontend is accessed via `http://localhost/doc_process/uae-docs-api/public/app.html`.

5.  **Testing**
    - Import `postman_collection.json` into Postman.
    - Set the `base_url` variable in Postman to your API URL (e.g., `http://localhost/doc_process/uae-docs-api/public/index.php`).
    - Run the requests to verify functionality.

## Frontend
- Open `http://localhost/doc_process/uae-docs-api/public/app.html` in your browser.
- Register a new user.
- Login to access the dashboard.
