<?php
namespace Controllers;

use Config\Database;
use Models\Category;
use Core\Response;
use Core\Auth;

class CategoryController {
    private $db;
    private $category;

    public function __construct() {
        $database = new Database();
        $this->db = $database->getConnection();
        $this->category = new Category($this->db);
    }

    public function index() {
        $stmt = $this->category->read();
        $categories = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        Response::json($categories);
    }

    public function create() {
        $user = Auth::validate();
        if ($user->role !== 'admin') {
            Response::error("Access denied", 403);
        }

        $data = json_decode(file_get_contents("php://input"));

        if (!empty($data->name) && !empty($data->description)) {
            $this->category->name = $data->name;
            $this->category->description = $data->description;

            if ($this->category->create()) {
                Response::json(["message" => "Category created successfully"], 201);
            } else {
                Response::error("Unable to create category", 503);
            }
        } else {
            Response::error("Incomplete data");
        }
    }

    public function update($id) {
        $user = Auth::validate();
        if ($user->role !== 'admin') {
            Response::error("Access denied", 403);
        }

        $data = json_decode(file_get_contents("php://input"));

        if (!empty($data->name) && !empty($data->description)) {
            $this->category->id = $id;
            $this->category->name = $data->name;
            $this->category->description = $data->description;

            if ($this->category->update()) {
                Response::json(["message" => "Category updated successfully"]);
            } else {
                Response::error("Unable to update category", 503);
            }
        } else {
            Response::error("Incomplete data");
        }
    }

    public function delete($id) {
        $user = Auth::validate();
        if ($user->role !== 'admin') {
            Response::error("Access denied", 403);
        }

        $this->category->id = $id;

        if ($this->category->delete()) {
            Response::json(["message" => "Category deleted successfully"]);
        } else {
            Response::error("Unable to delete category", 503);
        }
    }
}
