<?php
namespace Controllers;

use Config\Database;
use Models\Payment;
use Core\Response;
use Core\Request;
use Core\Auth;

class PaymentController {
    private $db;
    private $payment;

    public function __construct() {
        $database = new Database();
        $this->db = $database->getConnection();
        $this->payment = new Payment($this->db);
    }

    public function initiate() {
        $user = Auth::validate();
        $data = Request::getJsonBody();

        if (!empty($data->request_id) && !empty($data->amount)) {
            $this->payment->request_id = $data->request_id;
            $this->payment->amount = $data->amount;
            $this->payment->method = $data->method ?? 'credit_card';
            $this->payment->transaction_id = uniqid('txn_'); // Mock transaction ID

            if ($this->payment->create()) {
                Response::created([
                    "message" => "Payment initiated successfully", 
                    "transaction_id" => $this->payment->transaction_id,
                    "status" => "pending"
                ]);
            } else {
                Response::error("Unable to initiate payment", 503);
            }
        } else {
            Response::validationError();
        }
    }

    public function verify() {
        $user = Auth::validate();
        $data = Request::getJsonBody();

        if (!empty($data->transaction_id)) {
            $this->payment->transaction_id = $data->transaction_id;

            if ($this->payment->verify()) {
                Response::json(["message" => "Payment verified successfully", "status" => "completed"]);
            } else {
                Response::error("Unable to verify payment", 503);
            }
        } else {
            Response::validationError();
        }
    }
}
