<?php
namespace Controllers;

use Config\Database;
use Models\Service;
use Core\Response;
use Core\Request;
use Core\Auth;

class ServiceController {
    private $db;
    private $service;

    public function __construct() {
        $database = new Database();
        $this->db = $database->getConnection();
        $this->service = new Service($this->db);
    }

    public function index() {
        $stmt = $this->service->read();
        $services = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        Response::json($services);
    }

    public function show($id) {
        $this->service->id = $id;
        $service = $this->service->readOne();
        if ($service) {
            Response::json($service);
        } else {
            Response::error("Service not found", 404);
        }
    }

    public function create() {
        $user = Auth::validate();
        if ($user->role !== 'admin') {
            Response::error("Access denied", 403);
        }

        $data = Request::getJsonBody();

        if (!empty($data->category_id) && !empty($data->name) && !empty($data->base_price)) {
            $this->service->category_id = $data->category_id;
            $this->service->name = $data->name;
            $this->service->description = $data->description ?? '';
            $this->service->base_price = $data->base_price;
            $this->service->processing_time_days = $data->processing_time_days ?? 0;

            if ($this->service->create()) {
                Response::created(["message" => "Service created successfully"]);
            } else {
                Response::error("Unable to create service", 503);
            }
        } else {
            Response::validationError();
        }
    }

    public function update($id) {
        $user = Auth::validate();
        if ($user->role !== 'admin') {
            Response::error("Access denied", 403);
        }

        $data = Request::getJsonBody();

        if (!empty($data->category_id) && !empty($data->name) && !empty($data->base_price)) {
            $this->service->id = $id;
            $this->service->category_id = $data->category_id;
            $this->service->name = $data->name;
            $this->service->description = $data->description ?? '';
            $this->service->base_price = $data->base_price;
            $this->service->processing_time_days = $data->processing_time_days ?? 0;

            if ($this->service->update()) {
                Response::json(["message" => "Service updated successfully"]);
            } else {
                Response::error("Unable to update service", 503);
            }
        } else {
            Response::validationError();
        }
    }

    public function delete($id) {
        $user = Auth::validate();
        if ($user->role !== 'admin') {
            Response::error("Access denied", 403);
        }

        $this->service->id = $id;

        if ($this->service->delete()) {
            Response::json(["message" => "Service deleted successfully"]);
        } else {
            Response::error("Unable to delete service", 503);
        }
    }
}
