<?php
namespace Core;

use Core\Response;
use Core\JwtHandler;
use Config\Database;

class Auth {
    public static function validate() {
        $headers = apache_request_headers();
        $token = null;

        if (isset($headers['Authorization'])) {
            $matches = [];
            if (preg_match('/Bearer\s(\S+)/', $headers['Authorization'], $matches)) {
                $token = $matches[1];
            }
        }

        if (!$token) {
            Response::error("Unauthorized", 401);
        }

        $database = new Database();
        $db = $database->getConnection();
        $jwt = new JwtHandler($db);
        
        $userData = $jwt->validateToken($token);

        if (!$userData) {
            Response::error("Invalid or expired token", 401);
        }

        return $userData;
    }
}
