<?php
namespace Core;

class Response {
    public static function json($data, $status = 200) {
        http_response_code($status);
        header('Content-Type: application/json');
        echo json_encode($data);
        exit;
    }

    public static function error($message, $status = 400) {
        self::json(['error' => $message], $status);
    }

    public static function unauthorized($message = "Unauthorized") {
        self::error($message, 401);
    }

    public static function notFound($message = "Resource not found") {
        self::error($message, 404);
    }

    public static function created($data = []) {
        self::json($data, 201);
    }

    public static function validationError($message = "Incomplete or invalid data") {
        self::error($message, 400);
    }
}
