<?php
namespace Models;

use PDO;

class CustomerRequest {
    private $conn;
    private $table_name = "customer_requests";

    public $id;
    public $user_id;
    public $service_id;
    public $status;
    public $notes;
    
    // For document upload
    public $document_name;
    public $document_url;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = "INSERT INTO " . $this->table_name . " SET user_id=:user_id, service_id=:service_id, notes=:notes";
        $stmt = $this->conn->prepare($query);

        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->service_id = htmlspecialchars(strip_tags($this->service_id));
        $this->notes = htmlspecialchars(strip_tags($this->notes));

        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":service_id", $this->service_id);
        $stmt->bindParam(":notes", $this->notes);

        if ($stmt->execute()) {
            $this->id = $this->conn->lastInsertId();
            return true;
        }
        return false;
    }

    public function readByUser() {
        $query = "SELECT r.*, s.name as service_name, s.base_price 
                  FROM " . $this->table_name . " r 
                  LEFT JOIN services s ON r.service_id = s.id 
                  WHERE r.user_id = ? 
                  ORDER BY r.created_at DESC";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->user_id);
        $stmt->execute();
        return $stmt;
    }

    public function readOne() {
        $query = "SELECT r.*, s.name as service_name, s.base_price, u.name as user_name, u.email as user_email
                  FROM " . $this->table_name . " r 
                  LEFT JOIN services s ON r.service_id = s.id 
                  LEFT JOIN users u ON r.user_id = u.id
                  WHERE r.id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function updateStatus() {
        $query = "UPDATE " . $this->table_name . " SET status=:status WHERE id=:id";
        $stmt = $this->conn->prepare($query);
        
        $this->status = htmlspecialchars(strip_tags($this->status));
        $this->id = htmlspecialchars(strip_tags($this->id));
        
        $stmt->bindParam(":status", $this->status);
        $stmt->bindParam(":id", $this->id);
        
        if($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function addDocument() {
        $query = "INSERT INTO request_documents SET request_id=:request_id, document_name=:document_name, document_url=:document_url";
        $stmt = $this->conn->prepare($query);

        $this->id = htmlspecialchars(strip_tags($this->id)); // request_id
        $this->document_name = htmlspecialchars(strip_tags($this->document_name));
        $this->document_url = htmlspecialchars(strip_tags($this->document_url));

        $stmt->bindParam(":request_id", $this->id);
        $stmt->bindParam(":document_name", $this->document_name);
        $stmt->bindParam(":document_url", $this->document_url);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }
    
    public function getDocuments() {
        $query = "SELECT * FROM request_documents WHERE request_id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
