<?php
namespace Models;

use PDO;

class Payment {
    private $conn;
    private $table_name = "payments";

    public $id;
    public $request_id;
    public $amount;
    public $method;
    public $status;
    public $transaction_id;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = "INSERT INTO " . $this->table_name . " SET request_id=:request_id, amount=:amount, method=:method, status='pending', transaction_id=:transaction_id";
        $stmt = $this->conn->prepare($query);

        $this->request_id = htmlspecialchars(strip_tags($this->request_id));
        $this->amount = htmlspecialchars(strip_tags($this->amount));
        $this->method = htmlspecialchars(strip_tags($this->method));
        $this->transaction_id = htmlspecialchars(strip_tags($this->transaction_id));

        $stmt->bindParam(":request_id", $this->request_id);
        $stmt->bindParam(":amount", $this->amount);
        $stmt->bindParam(":method", $this->method);
        $stmt->bindParam(":transaction_id", $this->transaction_id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function verify() {
        // Mock verification logic
        $query = "UPDATE " . $this->table_name . " SET status='completed' WHERE transaction_id=:transaction_id";
        $stmt = $this->conn->prepare($query);
        
        $this->transaction_id = htmlspecialchars(strip_tags($this->transaction_id));
        $stmt->bindParam(":transaction_id", $this->transaction_id);
        
        if($stmt->execute()) {
            return true;
        }
        return false;
    }
}
