<?php
namespace Models;

use PDO;

class Service {
    private $conn;
    private $table_name = "services";

    public $id;
    public $category_id;
    public $name;
    public $description;
    public $base_price;
    public $processing_time_days;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function read() {
        $query = "SELECT s.id, s.category_id, c.name as category_name, s.name, s.description, s.base_price, s.processing_time_days, s.created_at 
                  FROM " . $this->table_name . " s
                  LEFT JOIN service_categories c ON s.category_id = c.id
                  ORDER BY s.created_at DESC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function show() {
        $query = "SELECT s.*, c.name as category_name FROM " . $this->table_name . " s 
                  LEFT JOIN service_categories c ON s.category_id = c.id 
                  WHERE s.id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function create() {
        $query = "INSERT INTO " . $this->table_name . " 
                  SET category_id=:category_id, name=:name, description=:description, 
                      base_price=:base_price, processing_time_days=:processing_time_days";
        $stmt = $this->conn->prepare($query);

        $this->category_id = htmlspecialchars(strip_tags($this->category_id));
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->description = htmlspecialchars(strip_tags($this->description));
        $this->base_price = htmlspecialchars(strip_tags($this->base_price));
        $this->processing_time_days = htmlspecialchars(strip_tags($this->processing_time_days));

        $stmt->bindParam(":category_id", $this->category_id);
        $stmt->bindParam(":name", $this->name);
        $stmt->bindParam(":description", $this->description);
        $stmt->bindParam(":base_price", $this->base_price);
        $stmt->bindParam(":processing_time_days", $this->processing_time_days);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function update() {
        $query = "UPDATE " . $this->table_name . " 
                  SET category_id=:category_id, name=:name, description=:description, 
                      base_price=:base_price, processing_time_days=:processing_time_days 
                  WHERE id=:id";
        $stmt = $this->conn->prepare($query);

        $this->category_id = htmlspecialchars(strip_tags($this->category_id));
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->description = htmlspecialchars(strip_tags($this->description));
        $this->base_price = htmlspecialchars(strip_tags($this->base_price));
        $this->processing_time_days = htmlspecialchars(strip_tags($this->processing_time_days));
        $this->id = htmlspecialchars(strip_tags($this->id));

        $stmt->bindParam(":category_id", $this->category_id);
        $stmt->bindParam(":name", $this->name);
        $stmt->bindParam(":description", $this->description);
        $stmt->bindParam(":base_price", $this->base_price);
        $stmt->bindParam(":processing_time_days", $this->processing_time_days);
        $stmt->bindParam(":id", $this->id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function delete() {
        $query = "DELETE FROM " . $this->table_name . " WHERE id=:id";
        $stmt = $this->conn->prepare($query);
        $this->id = htmlspecialchars(strip_tags($this->id));
        $stmt->bindParam(":id", $this->id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }
}
