<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: OPTIONS,GET,POST,PUT,DELETE");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit;
}

require __DIR__ . '/../vendor/autoload.php';

use Dotenv\Dotenv;
use Controllers\AuthController;
use Controllers\CategoryController;
use Controllers\ServiceController;
use Controllers\RequestController;
use Controllers\PaymentController;
use Core\Response;

// Load .env
$dotenv = Dotenv::createImmutable(__DIR__ . '/../');
$dotenv->safeLoad();

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = explode('/', $uri);

// Assuming the app is hosted at /doc_process/uae-docs-api/public/
// Adjust the offset based on your actual URL structure. 
// If localhost/doc_process/uae-docs-api/public/index.php/auth/login
// $uri[0] = empty
// $uri[1] = doc_process
// $uri[2] = uae-docs-api
// $uri[3] = public
// $uri[4] = auth
// $uri[5] = login

// Let's find where 'public' is and start from there
$key = array_search('public', $uri);
if ($key !== false) {
    $endpoint = isset($uri[$key + 1]) ? $uri[$key + 1] : null;
    $action = isset($uri[$key + 2]) ? $uri[$key + 2] : null;
    $param = isset($uri[$key + 3]) ? $uri[$key + 3] : null;
    // Handle cases like /requests/update/1 where action is update and param is 1
    // Or /requests/1/upload-document where action is 1 and param is upload-document
} else {
    // Fallback if not in 'public' folder explicitly or rewritten
    // This might need adjustment based on server config
    $endpoint = isset($uri[1]) ? $uri[1] : null;
    $action = isset($uri[2]) ? $uri[2] : null;
    $param = isset($uri[3]) ? $uri[3] : null;
}

$method = $_SERVER['REQUEST_METHOD'];

// Router
switch ($endpoint) {
    case 'auth':
        $controller = new AuthController();
        if ($action == 'register' && $method == 'POST') $controller->register();
        elseif ($action == 'login' && $method == 'POST') $controller->login();
        elseif ($action == 'logout' && $method == 'POST') $controller->logout();
        else Response::notFound("Endpoint not found");
        break;

    case 'user':
        $controller = new AuthController();
        if ($action == 'profile') {
            if ($method == 'GET') $controller->getProfile();
            elseif ($method == 'PUT') $controller->updateProfile();
            else Response::error("Method not allowed", 405);
        } else Response::notFound("Endpoint not found");
        break;

    case 'categories':
        $controller = new CategoryController();
        if (!$action && $method == 'GET') $controller->index();
        elseif ($action == 'create' && $method == 'POST') $controller->create();
        elseif ($action == 'update' && $param && $method == 'PUT') $controller->update($param);
        elseif ($action && $method == 'DELETE') $controller->delete($action); // /categories/{id}
        else Response::notFound("Endpoint not found");
        break;

    case 'services':
        $controller = new ServiceController();
        if (!$action && $method == 'GET') $controller->index();
        elseif ($action == 'create' && $method == 'POST') $controller->create();
        elseif ($action == 'update' && $param && $method == 'PUT') $controller->update($param);
        elseif (is_numeric($action) && $method == 'GET') $controller->show($action); // /services/{id}
        elseif (is_numeric($action) && $method == 'DELETE') $controller->delete($action); // /services/{id}
        else Response::notFound("Endpoint not found");
        break;

    case 'requests':
        $controller = new RequestController();
        if ($action == 'create' && $method == 'POST') $controller->create();
        elseif ($action == 'my' && $method == 'GET') $controller->myRequests();
        elseif ($action == 'update' && $param && $method == 'PUT') $controller->update($param);
        elseif (is_numeric($action) && $param == 'upload-document' && $method == 'POST') $controller->uploadDocument($action);
        elseif (is_numeric($action) && $method == 'GET') $controller->show($action);
        else Response::notFound("Endpoint not found");
        break;

    case 'payments':
        $controller = new PaymentController();
        if ($action == 'initiate' && $method == 'POST') $controller->initiate();
        elseif ($action == 'verify' && $method == 'POST') $controller->verify();
        else Response::notFound("Endpoint not found");
        break;

    default:
        Response::notFound("Endpoint not found");
        break;
}
